<?php

/**
 * Test Module
 *
 * @package blesta
 * @subpackage blesta.components.modules.test
 * @copyright Copyright (c) 2018, Phillips Data, Inc.
 * @license http://www.blesta.com/license/ The Blesta License Agreement
 * @link http://www.blesta.com/ Blesta
 */
class Test extends Module
{

    /**
     * Initializes the module
     */
    public function __construct()
    {
        // Load the language required by this module
        Language::loadLang('test', null, dirname(__FILE__) . DS . 'language' . DS);

        // Load module config
        $this->loadConfig(dirname(__FILE__) . DS . 'config.json');
    }

    /**
     * Returns the rendered view of the manage module page
     *
     * @param mixed $module A stdClass object representing the module and its rows
     * @param array $vars An array of post data submitted to or on the manager module
     *  page (used to repopulate fields after an error)
     * @return string HTML content containing information to display when viewing the manager module page
     */
    public function manageModule($module, array &$vars)
    {
        // Load the view into this object, so helpers can be automatically added to the view
        $this->view = new View('manage', 'default');
        $this->view->base_uri = $this->base_uri;
        $this->view->setDefaultView('components' . DS . 'modules' . DS . 'test' . DS);

        // Load the helpers required for this view
        Loader::loadHelpers($this, ['Html', 'Widget']);

        $this->view->set('module', $module);

        return $this->view->fetch();
    }

    /**
     * {@inheritdoc}
     */
    public function install()
    {
        // Perform install logic, such as installing cron tasks
        Loader::loadModels($this, ['CronTasks']);

        // Retrieve the cron task if it already exists for another company
        $task = $this->CronTasks->getByKey('hello_world', 'test', 'module');

        if (!$task) {
            // Create the automation task
            $task = [
                'key' => 'hello_world', // a string used to identify this cron task (see MyPluginPlugin::cron())
                'task_type' => 'module', // this cron task is for a module, so it must be set to 'module'
                'dir' => 'test', // the directory of this module
                'name' => 'Hello World Cron Task', // the name of this cron task
                'description' => 'This is a test cron task that simply outputs a statement when run.', // the description of this task
                'type' => 'interval' // "time" = once per day at a defined time, "interval" = every few minutes or hours
            ];
            $task_id = $this->CronTasks->add($task);
        } else {
            $task_id = $task->id;
        }

        // Create the cron task run for this company
        if ($task_id) {
            $task_run = array(
                //'time' => '14:25', // the daily 24-hour time that this task should run (optional, required if interval is not given)
                'interval' => '5', // the interval, in minutes, that this cron task should run (optional, required if time is not given)
                'enabled' => 1, // 1 if this cron task is enabled, 0 otherwise (optional, default 1)
            );
            $this->CronTasks->addTaskRun($task_id, $task_run);
        }
    }

    /**
     * {@inheritdoc}
     */
    public function uninstall($module_id, $last_instance)
    {
        // Perform uninstall logic, such as deleting cron tasks
        Loader::loadModels($this, ['CronTasks']);

        // Retrieve the cron task run for this company
        $cron_task_run = $this->CronTasks->getTaskRunByKey('hello_world', 'test', false, 'module');

        if ($last_instance) {
            // Delete all trace of this module, such as cron tasks
            // Remove the cron task altogether
            $cron_task = $this->CronTasks->getByKey('hello_world', 'test', 'module');
            if ($cron_task) {
                $this->CronTasks->deleteTask($cron_task->id, 'module', 'test');
            }
        }

        // Remove individual task run
        if ($cron_task_run) {
            $this->CronTasks->deleteTaskRun($cron_task_run->task_run_id);
        }
    }

    /**
     * {@inheritdoc}
     */
    public function cron($key)
    {
        switch ($key) {
            case 'hello_world':
                echo "Hello World! The Test module's cron task is currently being run.\n\n";
                break;
        }
    }
}
